/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kfiledialog.h>

// command includes
#include "askforfolderscommand.h"
#include "askforfolderswidget.h"

using namespace WorKflow;

AskForFoldersCommand::AskForFoldersCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  AskForFoldersWidget* w = new AskForFoldersWidget(this);
  setWidget(w);
}

AskForFoldersCommand::~AskForFoldersCommand()
{
}

void AskForFoldersCommand::execute()
{
  QString prompt = value("prompt").nextString();
  bool multiple = value("multiple").nextBoolean();

  QStringList res;

  if (multiple) {

  } else {
    QString dir = KFileDialog::getExistingDirectory(QString::null, widget(), prompt);
    if (dir.isEmpty()) {
      emit aborted();
      return;
    }

    res << dir;
  }

  setResult("folders", Value::stringList("org.kde.public.folder", res));
}

#include "askforfolderscommand.moc"
