/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COPYFILESCOMMAND_H
#define COPYFILESCOMMAND_H

// WorKflow includes
#include "command.h"

// forward declarations
class KURL;

namespace KIO
{
  class Job;
}

/**
 * @author Thomas Kadauke
 */
class CopyFilesCommand : public WorKflow::Command
{
  Q_OBJECT

public:
  CopyFilesCommand(WorKflow::Document* parent, WorKflow::CommandDescription* description);
  ~CopyFilesCommand();

  virtual void execute();

private slots:
  void showProgress(KIO::Job* job, const KURL& source, const KURL& dest);
  void setPercent(KIO::Job *job, unsigned long percent);

private:
  double m_prog;
};

#endif
