/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <kurl.h>
#include <kio/netaccess.h>
#include <kprocess.h>
#include <klocale.h>

// Qt includes
#include <qcursor.h>

// command includes
#include "flipimagecommand.h"
#include "flipimagewidget.h"
#include "flipimagedialog.h"
#include "checkbox.h"

using namespace WorKflow;

FlipImageCommand::FlipImageCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  FlipImageWidget* w = new FlipImageWidget(this);
  setWidget(w);

  // for now, this has to be here :(
  connect(w->m_interactiveCheckBox, SIGNAL(toggled(bool)), this, SIGNAL(sizeChanged()));
}

FlipImageCommand::~FlipImageCommand()
{
}

void FlipImageCommand::execute()
{
  QStringList files = value("images").asStringList();
  if (files.isEmpty())
    return;

  bool interactive = value("interactive").nextBoolean();

  if (interactive) {
    FlipImageDialog dialog(files, widget());
    dialog.exec();
  } else {
    bool horz = value("horz").nextBoolean();
    bool vert = value("vert").nextBoolean();

    int count = files.count();
    int num = 1;
    for (QStringList::ConstIterator i = files.begin(); i != files.end(); ++i, ++num) {
      emit progress(double(num) / double(count), i18n("Flipping image %1").arg(*i));
      flipImage(horz, vert, *i);
    }
  }

  Command::execute();
}

void FlipImageCommand::flipImage(bool horz, bool vert, const QString& fileName, QString dest)
{
  KURL url(fileName);

  if (url.isLocalFile()) {
    QString path = url.path();
    if (dest.isNull())
      dest = path;

    KProcess proc;
    proc << "convert";
    if (horz)
      proc << "-flop";
    if (vert)
      proc << "-flip";
    proc << path << dest;

    kapp->setOverrideCursor(QCursor(QCursor::BusyCursor));
    proc.start(KProcess::Block);
    kapp->restoreOverrideCursor();
  } else {
    // TODO
  }
}

#include "flipimagecommand.moc"
