/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kurl.h>
#include <klocale.h>

// Qt includes
#include <qwhatsthis.h>

// WorKflow includes
#include "imageviewer.h"

// command includes
#include "flipimagedialog.h"
#include "flipimagecommand.h"

FlipImageDialog::FlipImageDialog(const QStringList& files, QWidget* parent, const char* name, WFlags fl)
  : FlipImageDialogBase(parent,name,fl), m_files(files)
{
}

FlipImageDialog::~FlipImageDialog()
{
}

void FlipImageDialog::setScaleImage(bool scale)
{
  m_preview->setAutoScale(scale);
  updatePreview();
}

void FlipImageDialog::next()
{
  if (m_files.isEmpty()) {
    accept();
  } else {
    KURL url(m_files.first());
    m_current = url.path();

    m_files.pop_front();
    updatePreview();
  }
}

void FlipImageDialog::flipVertical()
{
  FlipImageCommand::flipImage(false, true, m_current);
  updatePreview();
}

void FlipImageDialog::flipHorizontal()
{
  FlipImageCommand::flipImage(true, false, m_current);
  updatePreview();
}

void FlipImageDialog::showHelpText()
{
  static QString helpText = i18n("You can use the buttons on the bottom of the window to process the images."
                                 "Additionally, the following keyboard shortcuts exist:"
                                 "<ul>"
                                 "<li><b>H</b>: Flip Horizontally"
                                 "<li><b>V</b>: Flip Vertically"
                                 "<li><b>N</b>: Next Image"
                                 "</ul>");

  QWhatsThis::display(helpText);
}

void FlipImageDialog::showEvent(QShowEvent*)
{
  next();
}

void FlipImageDialog::updatePreview()
{
  m_preview->setImage(m_current);
}

bool FlipImageDialog::event(QEvent* e)
{
  if (e->type() == QEvent::KeyPress) {
    QKeyEvent* event = static_cast<QKeyEvent*>(e);

    switch (event->key()) {
      case Qt::Key_H:
        flipHorizontal();
        return true;
      case Qt::Key_V:
        flipVertical();
        return true;
      case Qt::Key_N:
        next();
        return true;
      default:
        break;
    }
  }
  return QDialog::event(e);
}

#include "flipimagedialog.moc"
