/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef ROTATEIMAGEDIALOG_H
#define ROTATEIMAGEDIALOG_H

// Qt includes
#include <qstringlist.h>

// command includes
#include "rotateimagedialogbase.h"

class RotateImageDialog : public RotateImageDialogBase
{
  Q_OBJECT

public:
  RotateImageDialog(const QStringList& files, QWidget* parent = 0, const char* name = 0, bool modal = false, WFlags fl = 0 );
  ~RotateImageDialog();

protected:
  virtual bool event(QEvent* e);
  virtual void showEvent(QShowEvent* e);

protected slots:
  virtual void next();
  virtual void rotate180();
  virtual void rotateCCW();
  virtual void rotateCW();
  virtual void setScaleImage(bool scale);
  virtual void showHelpText();

private:
  void updatePreview();

  QStringList m_files;
  QString m_current;
};

#endif

