/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef SELECTLISTITEMSDIALOG_H
#define SELECTLISTITEMSDIALOG_H

#include "selectlistitemsdialogbase.h"

class SelectListItemsDialog : public SelectListItemsDialogBase
{
  Q_OBJECT

public:
  static bool select(QWidget* parent, const QString& title, const QString& prompt, bool allowMulti, bool allowEmpty, const QStringList& items, QStringList& result);

protected:
  SelectListItemsDialog(QWidget* parent, const QString& title, const QString& prompt, bool allowMulti, bool allowEmpty, const QStringList& items);
  ~SelectListItemsDialog();

  QStringList selectedItems();

protected slots:
  void selectAll();
  void invertSelection();

private slots:
  void slotSelectionChanged();

private:
  bool m_allowMulti;
  bool m_allowEmpty;
};

#endif

