/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kpushbutton.h>
#include <klistview.h>
#include <klocale.h>

// Qt includes
#include <qmap.h>

// WorKflow includes
#include "document.h"

// command includes
#include "selectvariabledialog.h"
#include "changevariablecommand.h"
#include "serviceinfo.h"
#include "modifyvariableservice.h"

using namespace WorKflow;

QString SelectVariableDialog::select(QWidget* parent, Document* document, int lastRow)
{
  SelectVariableDialog dialog(parent, document, lastRow);
  if (dialog.exec())
    return dialog.variableName();
  return QString::null;
}

SelectVariableDialog::SelectVariableDialog(QWidget* parent, Document* document, int lastRow)
  : SelectVariableDialogBase(parent)
{
  ServiceInfo info(document);
  ServiceInfo::List vars = info.query(lastRow, "modify_variable");

  // make sure only the most recent variable assignments are shown
  QMap<QString, QString> items;

  for (ServiceInfo::List::ConstIterator i = vars.begin(); i != vars.end(); ++i) {
    ModifyVariableService* var = static_cast<ModifyVariableService*>(*i);
    items.insert(var->name(), var->description());

/*    Command* cmd = document->commandAt(i);
    if (i != 0 && cmd->inherits("ChangeVariableCommand")) {
      ChangeVariableCommand* var = static_cast<ChangeVariableCommand*>(cmd);
      Command* before = document->commandAt(i - 1);
      items.insert(var->variableName(), i18n("Output of command \"%1\" (%2)").arg(before->title()).arg(i));
    }*/
  }

  for (QMap<QString, QString>::ConstIterator i = items.begin(); i != items.end(); ++i) {
    new KListViewItem(m_listView, i.key(), i.data());
  }
}

SelectVariableDialog::~SelectVariableDialog()
{
}

void SelectVariableDialog::slotSelectionChanged()
{
  QListViewItem* item = m_listView->selectedItem();
  m_okButton->setEnabled(item != 0);
}

QString SelectVariableDialog::variableName()
{
  QListViewItem* item = m_listView->selectedItem();
  if (item)
    return item->text(0);
  return QString::null;
}

#include "selectvariabledialog.moc"
