/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>

// Qt includes
#include <qlineedit.h>
#include <qcombobox.h>

// command includes
#include "showmessagecommand.h"
#include "showmessagewidget.h"

using namespace WorKflow;

ShowMessageCommand::ShowMessageCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  ShowMessageWidget* w = new ShowMessageWidget(this);
  setWidget(w);
}

ShowMessageCommand::~ShowMessageCommand()
{
}

void ShowMessageCommand::execute()
{
  QString type = value("type").enumKey();
  QString message = value("message").nextString();

  int button1 = buttonTypeFromIndex(value("button1").enumIndex());
  int button2 = buttonTypeFromIndex(value("button2").enumIndex());
  int button3 = buttonTypeFromIndex(value("button3").enumIndex());

  int res;
  if (type == "question") {
    res = QMessageBox::question(0, i18n("Question"), message, button1, button2, button3);
  } else if (type == "information") {
    res = QMessageBox::information(0, i18n("Information"), message, button1, button2, button3);
  } else if (type == "error") {
    res = QMessageBox::critical(0, i18n("Error"), message, button1, button2, button3);
  } else if (type == "warning") {
    res = QMessageBox::warning(0, i18n("Warning"), message, button1, button2, button3);
  } else {
    kdWarning() << k_funcinfo << "unknown message type" << endl;
  }

  if (res == QMessageBox::Cancel) {
    emit aborted();
  }

  Command::execute();
}

int ShowMessageCommand::buttonTypeFromIndex(int index)
{
  switch (index) {
    default: return QMessageBox::NoButton;
    case 1: return QMessageBox::Yes;
    case 2: return QMessageBox::No;
    case 3: return QMessageBox::Ok;
    case 4: return QMessageBox::Cancel;
  }
}

int ShowMessageCommand::indexFromButtonType(int type)
{
  switch (type) {
    default: return 0;
    case QMessageBox::Yes: return 1;
    case QMessageBox::No: return 2;
    case QMessageBox::Ok: return 3;
    case QMessageBox::Cancel: return 4;
  }
}

#include "showmessagecommand.moc"
