/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kio/netaccess.h>
#include <klocale.h>
#include <kurl.h>

// Qt includes
#include <qfile.h>
#include <qtextstream.h>

// command includes
#include "readtextfilescommand.h"

using namespace WorKflow;

ReadTextFilesCommand::ReadTextFilesCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
}

ReadTextFilesCommand::~ReadTextFilesCommand()
{
}

void ReadTextFilesCommand::execute()
{
  QStringList files = value("input").asStringList();
  QStringList text;

  int count = files.count();
  int num = 1;
  for (QStringList::ConstIterator i = files.begin(); i != files.end(); ++i, ++num) {
    QString target;

    // download the contents
    if (KIO::NetAccess::download(KURL(*i), target))
    {
      QFile file(target);

      if (file.open(IO_ReadOnly)) {
        emit progress(double(num) / double(count), i18n("Reading Text File \"%1\"").arg(*i));

        QTextStream stream(&file);
        QString line;

        while ((line = stream.readLine()) != QString::null) {
          text << line;
        }
        file.close();
      }

      KIO::NetAccess::removeTempFile(target);
    }
  }

  setResult("output", Value::stringList("org.kde.public.text", text));
}

#include "readtextfilescommand.moc"
