/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWAPPLICATIONMANAGER_H
#define WORKFLOWAPPLICATIONMANAGER_H

#include <qobject.h>

namespace WorKflow
{
  class ApplicationDescription;
  class Application;
  class Document;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke <tkadauke@gmx.de>
   */
  class ApplicationManager : public QObject
  {
    Q_OBJECT

  public:
    typedef QValueList<ApplicationDescription*> List;
    typedef QValueList<Application*> Instances;

    ApplicationManager(Document* parent);
    ~ApplicationManager();

    static void setMainApplication(const QString& id, const QString& dcopName);
    static Application* mainApplication();

    static void registerApplication(ApplicationDescription* app);
    static void unregisterApplication(ApplicationDescription* app);
    static ApplicationDescription* find(const QString& id);

    List query(bool unique);
    Application* findRunning(const QString& id);
    Instances running();
    Instances running(bool known, bool unique, int beforeRow = -1);

    Application* run(ApplicationDescription* app);
    void terminate(Application* instance);

  signals:
    void listChanged();

  private slots:
    void slotNewApplication(const QCString& name);
    void slotApplicationExit(const QCString& name);

  private:
    class Static;
    static Static* staticPart();
    static Static* s;

    class Private;
    Private* d;
  };
}

#endif
