/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <qdom.h>

// WorKflow includes
#include "xmldescription.h"

using namespace WorKflow;

XMLDescription::XMLDescription()
{
}

XMLDescription::~XMLDescription()
{
}

void XMLDescription::readXML(const QDomElement& e)
{
  QString id = e.attribute("id");
  if (id.isNull()) {
    kdWarning() << k_funcinfo << "no ID given in XML node" << endl;
    return;
  }

  m_id = id;

  QDomNode n = e.firstChild();
  while (!n.isNull()) {
    QDomElement e = n.toElement();
    if (!e.isNull()) {
      if (e.tagName() == "name")
        setName(e.text());
      else if (e.tagName() == "description")
        setDescription(e.text());
    }
    n = n.nextSibling();
  }
}

void XMLDescription::writeXML(QDomDocument& doc, QDomElement& e)
{
  e.setAttribute("id", m_id);

  QDomElement name = doc.createElement("name");
  QDomText text = doc.createTextNode(m_name);
  name.appendChild(text);

  QDomElement description = doc.createElement("description");
  text = doc.createTextNode(m_description);
  description.appendChild(text);

  e.appendChild(name);
  e.appendChild(description);
}

QString XMLDescription::id() const
{
  return m_id;
}

QString XMLDescription::name() const
{
  return m_name;
}

QString XMLDescription::description() const
{
  return m_description;
}

void XMLDescription::setId(const QString& id)
{
  m_id = id;
}

void XMLDescription::setName(const QString& name)
{
  m_name = name;
}

void XMLDescription::setDescription(const QString& desc)
{
  m_description = desc;
}
