/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <dcopclient.h>

// Qt includes
#include <qcombobox.h>
#include <qlistview.h>

// STL includes
#include <algorithm>
  using std::unique;

// designer includes
#include "dialoghelper.h"

// Helper functions
void DialogHelper::removeItem(QListView* view)
{
  QListViewItem* item = view->selectedItem();
  if (item) {
    delete item;
  }
}

void DialogHelper::itemUp(QListView* view)
{
  QListViewItem* item = view->selectedItem();
  if (!item->itemAbove())
    return;

  QListViewItem* above = item->itemAbove();
  above->moveItem(item);
}

void DialogHelper::itemDown(QListView* view)
{
  QListViewItem* item = view->selectedItem();
  if (!item->itemBelow())
    return;

  QListViewItem* dest = item->itemBelow();
  item->moveItem(dest);
}

bool DialogHelper::setComboBoxText(QComboBox* combo, const QString& text)
{
  for (int i = 0; i != combo->count(); i++) {
    if (combo->text(i) == text) {
      combo->setCurrentItem(i);
      return true;
    }
  }

  combo->setCurrentItem(0);
  return false;
}

void DialogHelper::fillEditComboBox(QComboBox* combo, const QStringList& strings)
{
  QString current = combo->currentText();
  combo->clear();
  combo->insertStringList(strings);
  combo->setEditText(current);
}

QStringList DialogHelper::dcopNames()
{
  DCOPClient* client = kapp->dcopClient();
  QCStringList apps = client->registeredApplications();

  QStringList strings;
  for (QCStringList::ConstIterator i = apps.begin(); i != apps.end(); ++i) {
    QString str = *i;
    str = str.left(str.findRev('-'));
    if (!str.startsWith("anonymous"))
      strings << str;
  }

  strings.sort();
  QStringList::Iterator i = unique(strings.begin(), strings.end());
  strings.erase(i, strings.end());

  return strings;
}

