/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>

// WorKflow includes
#include "commanddescription.h"
#include "command.h"
#include "commandwidget.h"
#include "document.h"

// designer includes
#include "editwidget.h"

using namespace WorKflow;

EditWidget::EditWidget(QWidget *parent, const char *name)
 : QWidget(parent, name), m_description(0), m_command(0), m_widget(0)
{
  setBackgroundColor(Qt::white);
  m_layout = new QGridLayout(this, 3, 3);
  m_layout->addItem(new QSpacerItem(0, 0, QSizePolicy::Fixed, QSizePolicy::Expanding), 0, 1);
  m_layout->addItem(new QSpacerItem(0, 0, QSizePolicy::Fixed, QSizePolicy::Expanding), 2, 1);
  m_layout->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Fixed), 1, 0);
  m_layout->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding, QSizePolicy::Fixed), 1, 2);

  m_document = new Document(this);
}

EditWidget::~EditWidget()
{
}

void EditWidget::setCommandDescription(CommandDescription* desc)
{
  if (!desc)
    return;

  if (m_widget)
    delete m_widget;

  if (m_command)
    delete m_command;

  m_document->clear();
  m_command = new Command(m_document, desc);
  m_widget = new CommandWidget(this, m_command);
  m_widget->show();
  m_layout->addWidget(m_widget, 1, 1);

  m_description = desc;
}

#include "editwidget.moc"
