/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klistview.h>
#include <kpushbutton.h>

// WorKflow includes
#include "commanddescription.h"
#include "parameterdescription.h"
#include "resultdescription.h"
// #include "commandmanager.h"
// #include "category.h"

// designer includes
#include "iowidget.h"
#include "parameterdialog.h"
#include "resultdialog.h"
#include "parameterlistitem.h"
#include "resultlistitem.h"
#include "dialoghelper.h"

using namespace WorKflow;

IoWidget::IoWidget(QWidget* parent, const char* name, WFlags fl)
  : IoWidgetBase(parent,name,fl)
{
  // disable sorting
  m_parametersListView->setSorting(-1);
  m_resultsListView->setSorting(-1);
}

IoWidget::~IoWidget()
{
}

// Input/Output Tab
void IoWidget::addParameter()
{
  ParameterDescription* desc = ParameterDialog::newParameter(this, m_description);
  if (desc) {
    new ParameterListItem(m_parametersListView, desc);
    m_description->addParameterDescription(desc);
  }
}

void IoWidget::editParameter()
{
  ParameterListItem* item = static_cast<ParameterListItem*>(m_parametersListView->selectedItem());
  if (item) {
    ParameterDescription* desc = item->parameter();
    if (ParameterDialog::editParameter(this, m_description, desc)) {
      item->update();
    }
  }
}

void IoWidget::removeParameter()
{
  ParameterListItem* item = static_cast<ParameterListItem*>(m_parametersListView->selectedItem());
  if (item) {
//     m_description->removeParameterDescription(item->parameter());
    delete item->parameter();
    DialogHelper::removeItem(m_parametersListView);
  }
}

void IoWidget::parameterUp()
{
  DialogHelper::itemUp(m_parametersListView);
  slotParameterSelectionChanged();
}

void IoWidget::parameterDown()
{
  DialogHelper::itemDown(m_parametersListView);
  slotParameterSelectionChanged();
}

void IoWidget::slotParameterSelectionChanged()
{
  QListViewItem* item = m_parametersListView->selectedItem();
  m_editParameterButton->setEnabled(item != 0);
  m_removeParameterButton->setEnabled(item != 0);
  m_parameterUpButton->setEnabled(item != 0 && item->itemAbove() != 0);
  m_parameterDownButton->setEnabled(item != 0 && item->itemBelow() != 0);
}

void IoWidget::addResult()
{
  ResultDescription* desc = ResultDialog::newResult(this, m_description);
  if (desc) {
    new ResultListItem(m_resultsListView, desc);
    m_description->addResultDescription(desc);
  }
}

void IoWidget::editResult()
{
  ResultListItem* item = static_cast<ResultListItem*>(m_resultsListView->selectedItem());
  if (item) {
    ResultDescription* desc = item->result();
    if (ResultDialog::editResult(this, m_description, desc)) {
      item->update();
    }
  }
}

void IoWidget::removeResult()
{
  ResultListItem* item = static_cast<ResultListItem*>(m_resultsListView->selectedItem());
  if (item) {
//     m_description->removeResultDescription(item->result());
    delete item->result();
    DialogHelper::removeItem(m_resultsListView);
  }
}

void IoWidget::resultUp()
{
  DialogHelper::itemUp(m_resultsListView);
  slotResultSelectionChanged();
}

void IoWidget::resultDown()
{
  DialogHelper::itemDown(m_resultsListView);
  slotResultSelectionChanged();
}

void IoWidget::slotResultSelectionChanged()
{
  QListViewItem* item = m_resultsListView->selectedItem();
  m_editResultButton->setEnabled(item != 0);
  m_removeResultButton->setEnabled(item != 0);
  m_resultUpButton->setEnabled(item != 0 && item->itemAbove() != 0);
  m_resultDownButton->setEnabled(item != 0 && item->itemBelow() != 0);
}

void IoWidget::setCommandDescription(CommandDescription* desc)
{
  m_description = desc;

  setEnabled(desc != 0);

  m_parametersListView->clear();
  m_resultsListView->clear();

  if (!desc)
    return;

  // fill parameter list view
  typedef CommandDescription::ParamDescList Params;
  Params params = m_description->parameters();

  for (Params::ConstIterator i = params.begin(); i != params.end(); ++i) {
    new ParameterListItem(m_parametersListView, *i);
  }

  // fill result list view
  typedef CommandDescription::ResultDescList Results;
  Results results = m_description->results();

  for (Results::ConstIterator i = results.begin(); i != results.end(); ++i) {
    new ResultListItem(m_resultsListView, *i);
  }
}

#include "iowidget.moc"
