/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

// WorKflow includes
#include "librarydescription.h"
#include "applicationdescription.h"
#include "commanddescription.h"
#include "datatype.h"
#include "category.h"
#include "conversion.h"

// designer includes
#include "librarywidget.h"
#include "librarylistitem.h"
#include "applicationdialog.h"
#include "commanddialog.h"
#include "categorydialog.h"
#include "datatypedialog.h"
#include "conversiondialog.h"
#include "dialoghelper.h"

using namespace WorKflow;

LibraryWidget::LibraryWidget(QWidget* parent, const char* name, WFlags fl)
  : LibraryWidgetBase(parent,name,fl), m_library(0)
{
  init();
}

LibraryWidget::~LibraryWidget()
{
}

void LibraryWidget::setLibrary(LibraryDescription* library)
{
  m_library = library;
  setEnabled(m_library != 0);
  init();
}

void LibraryWidget::init()
{
  m_listView->clear();

  m_applicationItem = new QListViewItem(m_listView, i18n("Applications"));
  m_commandItem = new QListViewItem(m_listView, i18n("Commands"));
  m_categoryItem = new QListViewItem(m_listView, i18n("Categories"));
  m_datatypeItem = new QListViewItem(m_listView, i18n("Datatypes"));
  m_conversionItem = new QListViewItem(m_listView, i18n("Conversions"));

  if (m_library) {
    typedef LibraryDescription::ApplicationList ApplicationList;
    typedef LibraryDescription::CommandList CommandList;
    typedef LibraryDescription::CategoryList CategoryList;
    typedef LibraryDescription::DatatypeList DatatypeList;
    typedef LibraryDescription::ConversionList ConversionList;

    ApplicationList applications = m_library->applications();
    for (ApplicationList::ConstIterator i = applications.begin(); i != applications.end(); ++i)
      new LibraryListItem(m_applicationItem, *i);

    CommandList commands = m_library->commands();
    for (CommandList::ConstIterator i = commands.begin(); i != commands.end(); ++i)
      new LibraryListItem(m_commandItem, *i);

    CategoryList categories = m_library->categories();
    for (CategoryList::ConstIterator i = categories.begin(); i != categories.end(); ++i)
      new LibraryListItem(m_categoryItem, *i);

    DatatypeList datatypes = m_library->datatypes();
    for (DatatypeList::ConstIterator i = datatypes.begin(); i != datatypes.end(); ++i)
      new LibraryListItem(m_datatypeItem, *i);

    ConversionList conversions = m_library->conversions();
    for (ConversionList::ConstIterator i = conversions.begin(); i != conversions.end(); ++i)
      new LibraryListItem(m_conversionItem, *i);
  }
}

void LibraryWidget::add()
{
  QListViewItem* item = m_listView->selectedItem();
  if (item->parent())
    item = item->parent();

  XMLDescription* desc;
  if (item == m_applicationItem) {
    desc = ApplicationDialog::newApplication(this, m_library);
  } else if (item == m_commandItem) {
    desc = CommandDialog::newCommand(this, m_library);
  } else if (item == m_categoryItem) {
    desc = CategoryDialog::newCategory(this, m_library);
  } else if (item == m_datatypeItem) {
    desc = DatatypeDialog::newDatatype(this, m_library);
  } else if (item == m_conversionItem) {
    desc = ConversionDialog::newConversion(this, m_library);
  }

  if (desc)
    new LibraryListItem(item, desc);
}

void LibraryWidget::edit()
{
  LibraryListItem* item = static_cast<LibraryListItem*>(m_listView->selectedItem());
  if (!item || !item->parent())
    return;

  if (item->parent() == m_applicationItem) {
    ApplicationDescription* desc = static_cast<ApplicationDescription*>(item->description());
    ApplicationDialog::editApplication(this, desc);
  } else if (item->parent() == m_commandItem) {
    CommandDescription* desc = static_cast<CommandDescription*>(item->description());
    CommandDialog::editCommand(this, desc);
  } else if (item->parent() == m_categoryItem) {
    Category* desc = static_cast<Category*>(item->description());
    CategoryDialog::editCategory(this, desc);
  } else if (item->parent() == m_datatypeItem) {
    Datatype* desc = static_cast<Datatype*>(item->description());
    DatatypeDialog::editDatatype(this, desc);
  } else if (item->parent() == m_conversionItem) {
    Conversion* desc = static_cast<Conversion*>(item->description());
    ConversionDialog::editConversion(this, desc);
  }

  item->update();
}

void LibraryWidget::remove()
{
  QListViewItem* item = m_listView->selectedItem();
  if (item->parent()) {
    if (KMessageBox::questionYesNo(this, i18n("Do you really want to delete this item?"), i18n("Delete item")) == KMessageBox::Yes) {
      LibraryListItem* item = static_cast<LibraryListItem*>(m_listView->selectedItem());
      delete item->description();
      DialogHelper::removeItem(m_listView);
    }
  }
}

void LibraryWidget::slotSelectionChanged()
{
  QListViewItem* item = m_listView->selectedItem();

  m_addButton->setEnabled(item != 0);
  m_editButton->setEnabled(item != 0 && item->parent() != 0);
  m_removeButton->setEnabled(item != 0 && item->parent() != 0);

  if (item && item->parent()) {
    LibraryListItem* libitem = static_cast<LibraryListItem*>(item);
    if (libitem->parent() == m_commandItem) {
      CommandDescription* desc = static_cast<CommandDescription*>(libitem->description());
      emit commandSelected(desc);
    }
  }
}

#include "librarywidget.moc"
