/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kpushbutton.h>

// WorKflow includes
#include "typemanager.h"

// designer includes
#include "selecttypedialog.h"
#include "typelistitem.h"

using namespace WorKflow;

Datatype* SelectTypeDialog::select(QWidget* parent)
{
  SelectTypeDialog dialog(parent);
  if (dialog.exec()) {
    TypeListItem* item = static_cast<TypeListItem*>(dialog.m_listView->selectedItem());
    if (item)
      return item->type();
  }

  return 0;
}

void SelectTypeDialog::init()
{
  TypeManager::TypeList types = TypeManager::self()->types();
  for (TypeManager::TypeList::ConstIterator i = types.begin(); i != types.end(); ++i)
    new TypeListItem(m_listView, *i);
}

SelectTypeDialog::SelectTypeDialog(QWidget* parent)
  : SelectTypeDialogBase(parent)
{
  init();
}

SelectTypeDialog::~SelectTypeDialog()
{
}

void SelectTypeDialog::slotSelectionChanged()
{
  QListViewItem* item = m_listView->selectedItem();
  m_okButton->setEnabled(item != 0);
}

#include "selecttypedialog.moc"
