/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "checkbox.h"
#include "parameter.h"

using namespace WorKflow;

class CheckBox::Private
{
public:
  Combiner combiner;
};

CheckBox::CheckBox(const QString& text, QWidget* parent, const char* name)
  : QCheckBox(text, parent, name), WidgetInterface()
{
  d = new Private;
  d->combiner = FirstValue;
  connect(this, SIGNAL(toggled(bool)), this, SLOT(slotChanged()));
}

CheckBox::CheckBox(QWidget* parent, const char* name)
  : QCheckBox(parent, name)
{
  d = new Private;
  d->combiner = FirstValue;
  connect(this, SIGNAL(toggled(bool)), this, SLOT(slotChanged()));
}

CheckBox::~CheckBox()
{
  delete d;
}

Value CheckBox::value()
{
  return Value::singleBoolean(parameter()->typeId(), isChecked());
}

void CheckBox::setValue(const Value& value)
{
  Value val = value;
  bool check;

  switch (d->combiner) {
    case FirstValue:
      check = val.nextBoolean();
      break;
    case AndValues:
      check = true;
      while (!val.isEmpty()) {
        check = check && val.nextBoolean();
      }
      break;
    case OrValues:
      check = false;
      while (!val.isEmpty()) {
        check = check || val.nextBoolean();
      }
      break;
    case MaxValues:
    case MinValues: {
      int trues = 0;
      int falses = 0;

      while (!val.isEmpty()) {
        if (val.nextBoolean())
          trues++;
        else
          falses++;
      }
      check = trues >= falses;
      if (d->combiner == MinValues)
        check = !check;
    }
    break;
  }

  setChecked(check);
}

CheckBox::Combiner CheckBox::combiner() const
{
  return d->combiner;
}

void CheckBox::setCombiner(Combiner comb)
{
  d->combiner = comb;
}

void CheckBox::slotChanged()
{
  if (!parameter())
    return;

  emit changed(value());
}

void CheckBox::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

QString CheckBox::parameterId() const
{
  return WidgetInterface::parameterId();
}

#include "checkbox.moc"
