/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWCHECKBOX_H
#define WORKFLOWCHECKBOX_H

// Qt includes
#include <qcheckbox.h>

// WorKflow includes
#include "widgetinterface.h"

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class CheckBox : public QCheckBox, public WorKflow::WidgetInterface
  {
    Q_OBJECT
    Q_ENUMS(Combiner)
    Q_PROPERTY(QString parameterId READ parameterId WRITE setParameterId)
    Q_PROPERTY(Combiner combiner READ combiner WRITE setCombiner)

  public:
    enum Combiner {
      FirstValue,
      AndValues,
      OrValues,
      MaxValues,
      MinValues
    };

    CheckBox(const QString& text, QWidget* parent, const char* name);
    CheckBox(QWidget* parent, const char* name);
    ~CheckBox();

    virtual Value value();

    virtual void setParameterId(const QString& paramId);
    virtual QString parameterId() const;

    Combiner combiner() const;
    void setCombiner(Combiner comb);

  public slots:
    virtual void setValue(const Value& value);

  private slots:
    void slotChanged();

  signals:
    void changed(const Value& value);

  private:
    class Private;
    Private* d;
  };
}

#endif
