/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef IMAGEVIEWER_H
#define IMAGEVIEWER_H

// Qt includes
#include <qscrollview.h>

class QImage;

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class ImageViewer : public QScrollView
  {
    Q_OBJECT
    Q_PROPERTY(bool zoomEnabled READ isZoomEnabled WRITE setZoomEnabled)
    Q_PROPERTY(bool dropEnabled READ isDropEnabled WRITE setDropEnabled)
    Q_PROPERTY(bool controlWidgetEnabled READ isControlWidgetEnabled WRITE setControlWidgetEnabled)
    Q_PROPERTY(bool autoScale READ isAutoScale WRITE setAutoScale)
    Q_PROPERTY(bool autoLoad READ isAutoLoad WRITE setAutoLoad)

  public:
    ImageViewer(QWidget* parent = 0, const char* name = 0, WFlags f = 0);
    ~ImageViewer();

    void setImage(const QImage& image);

    void setZoom(double newZoom);
    double zoom() const;

    void setZoomEnabled(bool enabled);
    void setDropEnabled(bool enabled);
    void setControlWidgetEnabled(bool enabled);
    void setAutoScale(bool enabled);
    void setAutoLoad(bool enabled);
    bool isZoomEnabled() const;
    bool isDropEnabled() const;
    bool isControlWidgetEnabled() const;
    bool isAutoScale() const;
    bool isAutoLoad() const;

  public slots:
    bool setImage(const QString& fileName);
    void zoomIn();
    void zoomOut();

  signals:
    void dropped(const QString& fileName);
    void zoomChanged(double newZoom);

  protected:
    virtual void enterEvent(QEvent*);
    virtual void leaveEvent(QEvent*);
    virtual void resizeEvent(QResizeEvent*);

    virtual void contentsContextMenuEvent(QContextMenuEvent* e);
    virtual void contentsDragEnterEvent(QDragEnterEvent* e);
    virtual void contentsDropEvent(QDropEvent* e);
    virtual void viewportMouseMoveEvent(QMouseEvent* e);
    virtual void viewportMousePressEvent(QMouseEvent* e);
    virtual void viewportMouseReleaseEvent(QMouseEvent* e);
    virtual void drawContents(QPainter* p, int, int, int, int);

  private:
    class Private;
    Private* d;
  };
}

#endif
