/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWSLIDER_H
#define WORKFLOWSLIDER_H

// Qt includes
#include <qslider.h>

// WorKflow includes
#include "widgetinterface.h"

namespace WorKflow
{
  /**
  @author Thomas Kadauke
  */
  class Slider : public QSlider, public WorKflow::WidgetInterface
  {
    Q_OBJECT
    Q_PROPERTY(QString parameterId READ parameterId WRITE setParameterId)

  public:
    Slider(int minValue, int maxValue, int pageStep, int value, Orientation o, QWidget* parent, const char* name);
    Slider(Orientation o, QWidget* parent, const char* name);
    Slider(QWidget* parent, const char* name);
    ~Slider();

    virtual QString parameterId() const;
    virtual Value value();
    virtual void setParameterId(const QString& paramId);

    virtual void setCommand(Command* cmd);

  public slots:
    virtual void setValue(const Value& value);

  signals:
    void changed(const Value& value);
    void enumNameChanged(const QString& name);

  private slots:
    void slotChanged();
  };
}

#endif
