/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#include "kateworkflowplugin.h"

#include <kaction.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kgenericfactory.h>
#include <kdebug.h>

#include <kapplication.h>
#include <dcopclient.h>

#include <workflow/editor.h>
#include <workflow/selectworkflowdialog.h>

class PluginView : public KXMLGUIClient
{
  friend class KateWorKflowPlugin;

public:
  Kate::MainWindow *win;
};

K_EXPORT_COMPONENT_FACTORY(libworkflow_kateplugin, KGenericFactory<KateWorKflowPlugin>("libworkflow_kateplugin"))

KateWorKflowPlugin::KateWorKflowPlugin(QObject* parent, const char* name, const QStringList&)
  : Kate::Plugin(static_cast<Kate::Application*>(parent), name)
{
}

KateWorKflowPlugin::~KateWorKflowPlugin()
{
}

void KateWorKflowPlugin::addView(Kate::MainWindow *win)
{
  /// @todo doesn't this have to be deleted?
  PluginView *view = new PluginView ();

  (void) new KAction(i18n("New Workflow"), 0, this,
                       SLOT(newWorkflow()), view->actionCollection(),
                       "new_workflow" );

  (void) new KAction(i18n("Edit Workflow"), 0, this,
                       SLOT(editWorkflow()), view->actionCollection(),
                       "edit_workflow" );

  (void) new KAction(i18n("Execute Workflow"), "run", 0, this,
                       SLOT(executeWorkflow()), view->actionCollection(),
                       "execute_workflow" );

  view->setInstance(new KInstance("kate"));
  view->setXMLFile("plugins/workflow_kate/plugin_workflow_kate.rc");
  win->guiFactory()->addClient(view);
  view->win = win;

  m_views.append (view);
}

void KateWorKflowPlugin::removeView(Kate::MainWindow *win)
{
  for (uint z=0; z < m_views.count(); z++)
    if (m_views.at(z)->win == win)
    {
      PluginView *view = m_views.at(z);
      m_views.remove (view);
      win->guiFactory()->removeClient (view);
      delete view;
    }
}

void KateWorKflowPlugin::newWorkflow()
{
  WorKflow::Editor::launch("org.kde.kate", kapp->dcopClient()->appId());
}

void KateWorKflowPlugin::editWorkflow()
{
  QString appid = kapp->dcopClient()->appId();

  QString filename = WorKflow::SelectWorkflowDialog::edit(application()->activeMainWindow()->centralWidget(), "org.kde.kate");
  if (!filename.isNull())
    WorKflow::Editor::launch("org.kde.kate", appid, filename);
}

void KateWorKflowPlugin::executeWorkflow()
{
  QString appid = kapp->dcopClient()->appId();

  QString filename = WorKflow::SelectWorkflowDialog::execute(application()->activeMainWindow()->centralWidget(), "org.kde.kate");
  kdDebug() << filename << endl;
  if (!filename.isNull())
    WorKflow::Editor::exec("org.kde.kate", appid, filename);
}

#include "kateworkflowplugin.moc"

