/***************************************************************************
 *   Copyright (C) 2010 by SIDDHARTH SHARMA siddharth.kde@gmail.com        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
* This file is Plasma Applet for Estimated Interest Skroogoid
*
* @author Siddharth SHARMA
*/

#include "tipsofthedayapplet.h"
#include "skgmainpanel.h"

#include <QGraphicsGridLayout>
#include <QGraphicsLinearLayout>



#include <plasma/widgets/iconwidget.h>
TipsOfTheDayApplet::TipsOfTheDayApplet(QObject* parent, const QVariantList& args)
    : Plasma::Applet(parent, args), m_layout()
{
    setAspectRatioMode(Plasma::IgnoreAspectRatio);

    tipDB = new KTipDatabase(SKGMainPanel::getMainPanel()->getTipOfDayFileName());

    QGraphicsLinearLayout* widget_layout = new  QGraphicsLinearLayout(Qt::Vertical);
    this->setLayout(widget_layout);

    QGraphicsLinearLayout* header_layout = new QGraphicsLinearLayout(Qt::Horizontal);
    widget_layout->addItem(header_layout);

    Plasma::IconWidget* ktip_icon = new Plasma::IconWidget();
    ktip_icon->setIcon(KIcon("ktip"));
    ktip_icon->setMaximumIconSize(QSize(32, 32));
    header_layout->addItem(ktip_icon);

    Plasma::Label* heading = new Plasma::Label();
    QFont heading_font = heading->font();
    heading_font.setBold(true);
    heading->setFont(heading_font);
    heading->setText(i18n("Did you know ...?"));
    heading->setAlignment(Qt::AlignHCenter);
    header_layout->addItem(heading);

    QGraphicsLinearLayout* lineLayout = new QGraphicsLinearLayout(Qt::Horizontal);
    widget_layout->addItem(lineLayout);

    // Add an icon to go to the previous tip
    previous_tip_button = new Plasma::ToolButton();
    previous_tip_button->setIcon(KIcon("arrow-left"));
    lineLayout->addItem(previous_tip_button);
    previous_tip_button->setActive(false);
    connect(previous_tip_button, SIGNAL(clicked()), this, SLOT(previousClicked()));

    // Add the label containing the tip
    displayLabel = new Plasma::Label();
    displayLabel->setAlignment(Qt::AlignTop);
    lineLayout->addItem(displayLabel);
    KTipDatabase db(SKGMainPanel::getMainPanel()->getTipOfDayFileName());
    displayLabel->setText(SKGServices::htmlToString(db.tip()));

    // Add an icon to go to the next tip
    next_tip_button = new Plasma::ToolButton();
    next_tip_button->setIcon(KIcon("arrow-right"));
    lineLayout->addItem(next_tip_button);
    connect(next_tip_button, SIGNAL(clicked()), this, SLOT(nextClicked()));

    // Add a spacer
    widget_layout->addStretch();


}

void TipsOfTheDayApplet::nextClicked()
{

    tipDB->nextTip();
    displayLabel->setText(SKGServices::htmlToString(tipDB->tip()));

}

void TipsOfTheDayApplet::previousClicked()
{
    tipDB->prevTip();
    displayLabel->setText(SKGServices::htmlToString(tipDB->tip()));

}


TipsOfTheDayApplet::~TipsOfTheDayApplet()
{

}


#include "tipsofthedayapplet.moc"
