<?php
/**
 * $Horde: imp/fetchmailprefs.php,v 1.25 2003/06/17 07:53:44 slusarz Exp $
 *
 * Copyright 2002-2003 Nuno Loureiro <nuno@co.sapo.pt>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
$authentication = OP_HALFOPEN;
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Fetchmail.php';

$account = new Account();
$onlynew = 0;
$to_edit = null;

$actionID = Horde::getFormData('actionID');

// Handle clients without javascript.
if (is_null($actionID)) {
    if (Horde::getPost('edit')) {
        $actionID = 'fetchmail_prefs_edit';
    } elseif (Horde::getPost('save')) {
        $actionID = 'fetchmail_prefs_save';
    } elseif (Horde::getPost('delete')) {
        $actionID = 'fetchmail_prefs_delete';
    } elseif (Horde::getPost('back')) {
        header('Location: ' . Horde::applicationUrl('prefs.php', true));
        exit;
    }
}

/* Run through the action handlers */
switch ($actionID) {
case 'fetchmail_prefs_edit':
    $to_edit = Horde::getFormData('account');
    break;

case 'fetchmail_prefs_save':
    $edit_account = Horde::getFormData('edit_account');
    $id = Horde::getFormData('id');

    if (!isset($edit_account) || ($edit_account == '')) {
        $edit_account = $account->add();
    }

    if (isset($id) && !empty($id)) {
        $account->setValue('id', $id, $edit_account);
    } else {
        $account->setValue('id', _("Unnamed"), $edit_account);
        $id = _("Unnamed");
    }

    $params = array('protocol', 'server', 'username', 'password', 'rmailbox',
                    'lmailbox', 'onlynew', 'del', 'markseen', 'loginfetch',
                    'acctcolor');
    foreach ($params as $val) {
        $account->setValue($val, Horde::getFormData($val), $edit_account);
    }

    $account->save();

    unset($to_edit);

    if (array_sum($account->getAll('loginfetch'))) {
        $prefs->setValue('fetchmail_login', 1);
    } else {
        $prefs->setValue('fetchmail_login', 0);
    }

    $notification->push(sprintf(_("The account \"%s\" has been saved."), $id), 'horde.success');

    break;

case 'fetchmail_prefs_delete':
    $to_delete = Horde::getFormData('edit_account');
    if (!is_null($to_delete)) {
        $deleted_account = $account->delete($to_delete);
        $notification->push(sprintf(_("The account \"%s\" has been deleted."), $deleted_account[0]['id']), 'horde.success');
    } else {
        $notification->push(_("You must select an account to be deleted."), 'horde.warning');
    }
    break;

}

$title = _("IMAP/POP3 Accounts");
$js_onLoad = null;
$accounts = $account->getAll('id');

require IMP_TEMPLATES . '/common-header.inc';
IMP::menu();
IMP::status();
$prefsPage = 'true';
require IMP_TEMPLATES . '/fetchmail/fetchmail_js.inc';
require IMP_TEMPLATES . '/fetchmail/manage.inc';
require IMP_TEMPLATES . '/common-footer.inc';
