<?php
/**
 * Implementation of the Quota API for MDaemon servers.
 *
 * Parameters required:
 *   'app_location'  --  TODO
 *
 * $Horde: imp/lib/Quota/mdaemon.php,v 1.7 2003/04/28 21:25:22 slusarz Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.7 $
 * @since   IMP 4.0
 * @package imp.quota
 */
class IMP_Quota_mdaemon extends IMP_Quota {
    
    /**
     * Get quota HTML to push to user.
     *
     * @access public
     *
     * @return string  The HTML representation of the quota data.
     */
    function quotaHTML()
    {
        global $imp;

        $userDetails = $this->_getUserDetails($imp['user'], $imp['maildomain']);

        if ($userDetails !== false) {
            $userHome = trim(substr($userDetails, 105, 90));
            $total = intval(substr($userDetails, 229, 6)) * 1024;

            if ($total == 0) {
                return $this->_quotaHTML(0, 0);
            }

            if (($taken = $this->_mailboxSize($userHome)) !== false) {
                return $this->_quotaHTML($taken, $total);
            }
        }

        return $this->_quotaError(_("Unable to retrieve quota"));
    }

    /**
     * Get the size of a mailbox
     *
     * @access private
     *
     * @param string $path  The full path of the mailbox to fetch the quota
     *                     for including trailing backslash.
     *
     * @return mixed  The number of bytes in the mailbox (integer) or false
     *                (boolean) on error.
     */
    function _mailboxSize($path)
    {
        $fp = @fopen($path . '\imap.mrk', 'rb');
        $contents = @fread($fp, filesize($path . '\imap.mrk'));
        @fclose($fp);

        $pointer = 36;
        $size = 0;
        while ($pointer < strlen($contents)) {
            $details = unpack('a17Filename/a11Crap/VSize', substr($contents, $pointer, 36));
            $size += $details['Size'];
            $pointer += 36;
        }

        /* Recursivly check subfolders. */
        $d = dir($path);
        while (($entry = $d->read()) !== false) {
            if (($entry != '.') &&
                ($entry != '..') &&
                (substr($entry, -5, 5) == '.IMAP')) { 
                $size += $this->_mailboxSize($path . $entry . '\\');
            }
        }
        $d->close();

        return $size;
    }

    /**
     * Retreive relevant line from userlist.dat.
     *
     * @param $user   The username for which to retrieve detals.
     * @param $realm  The realm (domain) for the user.
     *
     * @return mixed  Line from userlist.dat (string) or false (boolean).
     */
    function _getUserDetails($user, $realm)
    {
        $searchString = str_pad($realm, 45) . str_pad($user, 30);

        if (!($fp = fopen($this->_params['app_location'] . '/userlist.dat', 'rb'))) {
            return false;
        }

        while (!feof($fp)) {
            $line = fgets($fp, 4096);
            if (substr($line, 0, strlen($searchString)) == $searchString) {
                fclose($fp);
                return $line;
            }
        }
        fclose($fp);

        return false;
    }

}
