<?php
/**
 * $Horde: horde/lib/Block/color.php,v 1.4 2003/07/31 03:29:49 chuck Exp $
 *
 * @package Horde
 */
class Horde_Block_color extends Horde_Block {

    /**
     * Constructor.
     */
    function Horde_Block_color($params = array())
    {
        $this->_params = $params;
        $this->_app = 'horde';
        $this->_type = 'color';
    }

    /**
     * Does this block have any user editable parameters?
     *
     * @return boolean  True is there are editable parameters.
     *                  False if there are not.
     */
    function isEditable()
    {
        return true;
    }

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title()
    {
        return _("Color");
    }

    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content()
    {
        $html  = '<table width="100" height="100" bgcolor="%s">';
        $html .= '<tr><td>&nbsp;</td></tr>';
        $html .= '</table>';

        return sprintf($html, $this->_params['color']);
    }

}
