<?php
/**
 * $Horde: nag/addlink.php,v 1.4 2003/02/28 02:27:09 chuck Exp $
 *
 * Add Link API for Horde_Links into Nag
 *
 * Copyright 2003, Jeroen Huinink <j.huinink@wanadoo.nl>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

$return_url = Horde::getFormData('url');
$link_type = Horde::getFormData('link_type');
$reverse = (substr($link_type, -8) == '/reverse') ? '/reverse' : '';
if (!empty($reverse)) {
    $link_type = substr($link_type, 0, -8);
}
$from_application = Horde::getFormData('from_application');
$from_parameters = @unserialize(Horde::getFormData('from_parameters'));
$to_application = Horde::getFormData('to_application');
if (!empty($to_application)) {
    require_once HORDE_BASE . '/lib/Links.php';
    $links = &Horde_Links::singleton($registry->getApp());

    $to_parameters = @unserialize(Horde::getFormData('to_parameters'));
    if (!empty($reverse)) {
        $status = $links->addLink($to_application, $to_parameters, $from_application, $from_parameters, $link_type);
    } else { 
        $status = $links->addLink($from_application, $from_parameters, $to_application, $to_parameters, $link_type);
    }
    if (is_a($status, 'PEAR_Error')) {
        $notification->push($status, 'horde.error');
    } elseif ($registry->hasMethod($to_application . '/getLinkSummary')) {
        $notification->push(sprintf(_("Added a %s link to %s."), $link_type,
                                    $registry->call($to_application . '/getLinkSummary', $to_parameters)), 'horde.success');
    } else {
        $notification->push(_("Link added."), 'horde.success');
    }

    header('Location: ' . $return_url);
    exit;
}

/* Allow preferred theme to override settings. */
Horde::getThemeConfig(NAG_BASE);

/* Sort out the sorting values and task filtering. */
if (($sortby = Horde::getFormData('sortby')) !== null) {
    $prefs->setValue('sortby', $sortby);
}
if (($sortdir = Horde::getFormData('sortdir')) !== null) {
    $prefs->setValue('sortdir', $sortdir);
}
if (($show_completed = Horde::getFormData('show_completed')) !== null) {
    $prefs->setValue('show_completed', $show_completed);
}

/* Get the full, sorted task list. */
$tasks = Nag::listTasks($prefs->getValue('sortby'),
                        $prefs->getValue('sortdir'));

/* Page variables. */
$i = 0;
$title = _("Add Follow-up Task");
$js_onLoad = null;

$list = Horde::selfURL(false);
$all_link = Horde::link(Horde::addParameter($list, 'show_completed=1'), _("All tasks"), 'menuitem') . _("All tasks") . '</a>';
$complete_link = Horde::link(Horde::addParameter($list, 'show_completed=2'), _("Complete tasks"), 'menuitem') . _("Complete tasks") . '</a>';
$incomplete_link = Horde::link(Horde::addParameter($list, 'show_completed=0'), _("Incomplete tasks"), 'menuitem') . _("Incomplete tasks") . '</a>';
switch ($prefs->getValue('show_completed')) {
 case 1: // All tasks
     $all_link = _("All tasks");
     break;

 case 0: // Incomplete tasks
     $incomplete_link = _("Incomplete tasks");
     break;

 case 2: // Complete tasks
     $complete_link = _("Complete tasks");
     break;
}

require NAG_TEMPLATES . '/common-header.inc';
require_once HORDE_BASE . '/lib/Menu.php';
$tasklists = Nag::listTasklists();
require NAG_TEMPLATES . '/addlink/menu.inc';
$notification->notify();
require NAG_TEMPLATES . '/list/javascript.inc';
require NAG_TEMPLATES . '/addlink/header.inc';

if (count($tasks)) {
    require NAG_TEMPLATES . '/addlink/task_headers.inc';

    foreach ($tasks as $task_id => $task) {
        if (!empty($task['completed'])) {
            $style = 'closed';
        } else {
            $style = 'text' . $task['priority'];
        }
        $addurl = Horde::selfUrl(false);
        $addurl = Horde::addParameter($addurl, 'to_application', $registry->getParam('provides'));
        $addurl = Horde::addParameter($addurl, 'from_application', $from_application);
        $addurl = Horde::addParameter($addurl, 'from_parameters', serialize($from_parameters));
        $addurl = Horde::addParameter($addurl, 'url', $return_url);
        $addurl = Horde::addParameter($addurl, 'link_type', $link_type . $reverse);
        $share = $GLOBALS['nag_shares']->getShare($task['tasklist_id']);

        $owner = $task['tasklist_id'];
        if (!is_a($share, 'PEAR_Error') && $owner != $share->getOwner()) {
            $owner = $share->getShareName();
        }

        require NAG_TEMPLATES . '/addlink/task_summaries.inc';
    }

    require NAG_TEMPLATES . '/list/task_footers.inc';
} else {
    require NAG_TEMPLATES . '/list/empty.inc';
}

require NAG_TEMPLATES . '/list/footer.inc';
require NAG_TEMPLATES . '/common-footer.inc';
